package gov.va.vamf.scheduling.direct.resource;


import com.agilex.healthcare.veteranappointment.resources.AbstractUserResource;
import gov.va.vamf.scheduling.direct.datalayer.appointment.ExpressCareReasonService;
import gov.va.vamf.scheduling.direct.domain.ExpressCareReason;
import gov.va.vamf.security.v1.VamfJwtClaimsConstants;
import gov.va.vamf.security.v1.filters.JwtRbacRestricted;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Path("/express-care-service/")
@Component
@Scope("request")
public class ExpressCareReasonResource extends AbstractUserResource {

    @Resource
    private ExpressCareReasonService expressCareReasonService;

    @GET
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    @Path("reasons")
    @JwtRbacRestricted(VamfJwtClaimsConstants.VAMF_ROLE_VETERAN)
    public List<ExpressCareReason> fetchExpressCareReasons() {
        List<ExpressCareReason> expressCareReasons = expressCareReasonService.fetch();
        return expressCareReasons;
    }

}
